local metadata = {
"## Interface: FS15 1.1.0.0 RC12",
"## Title: MischStation",
"## Notes: placable MischStation for forage",
"## Author: Marhu",
"## Version: 3.0.0",
"## Date: 08.11.2014",
}

local function name() for i=1,table.getn(metadata) do local _,n=string.find(metadata[i],"## Title: ");if n then return (string.sub (metadata[i], n+1)); end;end;end;
local function version() for i=1,table.getn(metadata) do local _,n=string.find(metadata[i],"## Version: ");if n then return (string.sub (metadata[i], n+1)); end;end;end;

local function Debug(printDebug,...)
	if printDebug then
		local text, TITLE, VERSION = "","Marhus Mod",""
		for i = 1, select("#", ...) do
			if type(select(i, ...)) == "boolean" then
				text = text..(select(i, ...) and "true" or "false").." ";
			else text = text..(select(i, ...) or "nil").." "; end;
		end
		TITLE = (name())
		VERSION = " v"..(version())
		print(TITLE..VERSION..": "..text);
	end;
end;

MischStation = {};
MischStation.Dir = g_currentModDirectory;
MischStation_mt = nil;

local nBeginn, nEnde = string.find(MischStation.Dir,"MischStation");
if nBeginn then
	MischStation_mt = Class(MischStation, Placeable);
else
	MischStation.RunAsGE = true;
	MischStation_mt = Class(MischStation, Object);
end

InitObjectClass(MischStation, "MischStation");

function MischStation.onCreate(id)
	local MS = MischStation:new(g_server ~= nil, g_client ~= nil);
    g_currentMission:addOnCreateLoadedObject(MS);
    MS:load(id);
    MS:register(true);
end;

function MischStation:new(isServer, isClient, customMt)
	local mt = customMt;
    if mt == nil then
        mt = MischStation_mt;
    end;
	
    local self = {};
	if MischStation.RunAsGE then
		self = Object:new(isServer, isClient, mt)
	else
		self = Placeable:new(isServer, isClient, mt);
		registerObjectClassName(self, "MischStation");
	end;
	return self;
end;

function MischStation:delete()
   
	if self.PlayerTrigger then removeTrigger(self.PlayerTrigger); end;
	if self.isServer then
		if self.TipTriggers then
			for i = 1 ,table.getn(self.TipTriggers) do
				if self.TipTriggers[i].BaleTrigger then
					removeTrigger(self.TipTriggers[i].BaleTrigger);
				end;
				self.TipTriggers[i]:delete()
			end;
		end;
		if self.ForageTrigger then self.ForageTrigger:delete() end;
	end;
	if self.MixerSound and self.MixerSoundOn then
		setVisibility(self.MixerSound, false);
		self.MixerSoundOn = nil;
	end;
	
	unregisterObjectClassName(self);
    MischStation:superClass().delete(self);
	
end;

function MischStation:deleteFinal()
    MischStation:superClass().deleteFinal(self);
end;

function MischStation:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
		
	if not MischStation.RunAsGE then
		if not MischStation:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
			return false;
		end;
	else
		self.nodeId = xmlFilename;
    end;
		
	if not moveMode then
				
		self.db = {
			name = "MischStation",
			debug = false
		};
		
		if g_currentMission.DatenBank then
			g_currentMission.DatenBank.Add(self,self.db);
		end;
		
		self.optionen = {
			name = "MischStation",
			desc = "MischStation",
			type = 'group',
			args = {
				debuging = {
					name = "Debug",
					desc = "Print Debug info in Log",
					type = 'toggle',
					get = function() return self.db.debug end,
					set = function(info, newValue)
						self.db.debug = newValue
					end
				}
			}
		}
		
		self.updateTick = MischStation.updateTick;
		self.getNoAllowedText = MischStation.getNoAllowedText;
		self.getTipTriggerFillLevel = MischStation.getTipTriggerFillLevel;
		self.getHasSpaceForTipping = MischStation.getHasSpaceForTipping;
		self.getTipInfoForTrailer = MischStation.getTipInfoForTrailer;
		self.updateTrailerTipping = MischStation.updateTrailerTipping;
		--self.addShovelFillLevel = MischStation.addShovelFillLevel;
		
		self.SetLamp = MischStation.SetLamp;
		self.updateLamp = MischStation.updateLamp;
		self.updatePlane = MischStation.updatePlane;
		
		self.updateMs = 0;
		self.updateMin = 0;
		self.updateIntervall = 10;
		self.MixTypLvl = {} 
		self.MixTypName = {}
		self.fillTypeToMixType = {}
		self.MixTypFac = {}
		self.MixLvl = 0;
		self.TipTriggers = {}
		self.trailerTipTrigger = {}
		self.MapPfad = "";
		
		if MischStation.RunAsGE then
			self.MapPfad = Utils.getNoNil(getUserAttribute(self.nodeId,"MapPfad"),"");
			--Debug(self.db.debug,MischStation.Dir..self.MapPfad.."modDesc.xml")
			if fileExists(MischStation.Dir..self.MapPfad.."modDesc.xml") then
				--Debug(self.db.debug,"find modDesc.xml")
				local xmlmodDesc = loadXMLFile("xmltemp", MischStation.Dir..self.MapPfad.."modDesc.xml")
				local i, fine = 0, false;
				repeat
					local baseName = string.format("modDesc.l10n.text(%d)", i)
					local name = getXMLString(xmlmodDesc, baseName .. "#name")
					if name == nil then
						fine = true;
					else
						local text = getXMLString(xmlmodDesc, baseName .. "." .. g_languageShort)
						if text == nil then
							text = getXMLString(xmlmodDesc, baseName .. ".en")
							if text == nil then
							  text = getXMLString(xmlmodDesc, baseName .. ".de")
							end
						end
						if text ~= nil then
							if not g_i18n:hasModText(name) then
							   g_i18n:setText(name, text)
							end
						end
					end
					i = i + 1
				until fine == true;
				i, fine = 0, false;
				repeat
					local baseName = string.format("modDesc.inputBindings.input(%d)", i)
					if not hasXMLProperty(xmlmodDesc, baseName) then
						fine = true;
					else
						InputBinding.loadInputButtonFromXML(xmlmodDesc, baseName, false, g_currentMission.loadingMapModName, true)
					end
					i = i + 1
				until fine == true;
			end;
		end;
				
		local L_Name = getUserAttribute(self.nodeId,"L_Name");
		local L_Voll = Utils.getNoNil(getUserAttribute(self.nodeId,"L_Voll"),"voll");
		local L_SiloLeer = Utils.getNoNil(getUserAttribute(self.nodeId,"L_SiloLeer"),"SiloLeer");
		
		if L_Name and L_Name ~= "" then
			self.name = g_i18n:getText(L_Name).." ";
		else
			g_currentMission.numMischStation = (g_currentMission.numMischStation or 0) + 1;
			self.name = g_i18n:getText("MischStation").." "..g_currentMission.numMischStation.." ";
		end;
				
		--Debug(self.db.debug,string.format("load( %s) as GE %s",self.name,tostring(MischStation.RunAsGE)));
		
		self.MSG = {}
		self.MSG["voll"] = {msg = self.name..g_i18n:getText(L_Voll), send = true};
		
		self.foragePerHour = Utils.getNoNil(getUserAttribute(self.nodeId,"foragePerHour"),  1000);
		
		local ForageTriggerIndex = getUserAttribute(self.nodeId,"ForageTriggerIndex");
		if ForageTriggerIndex ~= nil then   
			local ForageTrigger = Utils.indexToObject(self.nodeId, ForageTriggerIndex);
			if ForageTrigger ~= nil then
				local trigger = MultiSiloTrigger:new(self.isServer, self.isClient);
				trigger:load(ForageTrigger);
				trigger:register(true);
				trigger.fillType = Fillable.FILLTYPE_FORAGE
				local fillType = getUserAttribute(ForageTrigger, "fillType");
				if fillType ~= nil then
					local desc = Fillable.fillTypeNameToDesc[fillType];
					if desc ~= nil then trigger.fillType = desc.index end;
				end;  
				self.ForageTrigger = trigger
				EffectManager:loadFromNode(self.ForageTrigger.rootNode,self.ForageTrigger)
				function self.ForageTrigger:update(dt) end;
				local org_getIsActivatable = self.ForageTrigger.getIsActivatable
				self.ForageTrigger.getIsActivatable = function(...)
					local s = select(1,...)
					if s.siloTrailer and s.siloTrailer.mixerWagonSuperAllowFillType and not s.siloTrailer:mixerWagonSuperAllowFillType(s.siloTrailer, false) then
						return false
					end
					return org_getIsActivatable(...)
				end
				local SchneckeIndex = getUserAttribute(self.nodeId,"Schnecke");
				if SchneckeIndex ~= nil then   
					local Schnecke = Utils.indexToObject(self.nodeId, SchneckeIndex);
					if Schnecke ~= nil then
						self.ForageTrigger.Schnecke = Schnecke;
					end;
				end;
			end;
			if getName(getParent(ForageTrigger)) == "RefPS" then
				self.ForageTriggerRaycast = getParent(ForageTrigger);
			end
		end;
		
		local TipTriggerIndex = getUserAttribute(self.nodeId, "TipTriggerIndex");
		local WalzenIndex = getUserAttribute(self.nodeId, "Walzen");
		local TipMarkerIndex = getUserAttribute(self.nodeId, "TipMarker");
		local BaleTriggerIndex = getUserAttribute(self.nodeId, "BaleTrigger");
		local ShovelTargetIndex = getUserAttribute(self.nodeId, "ShovelTarget");
		
		if TipTriggerIndex then
			local tipTriggersId = Utils.indexToObject(self.nodeId, TipTriggerIndex);
			local WalzenId = Utils.indexToObject(self.nodeId, WalzenIndex);
			local TipMarkerId = Utils.indexToObject(self.nodeId, TipMarkerIndex);
			local BaleTriggerId = Utils.indexToObject(self.nodeId, BaleTriggerIndex);
			local ShovelTargetId = Utils.indexToObject(self.nodeId, ShovelTargetIndex);
			if tipTriggersId then
				local numChildren = getNumOfChildren(tipTriggersId);
				for i=1,numChildren do
					local acceptedFillTypes = {}
					local childId = getChildAt(tipTriggersId, i-1);
					local Typ = getUserAttribute(childId, "Type")
					local MixFac = getUserAttribute(childId, "MixFac")
					local reFill = getUserAttribute(childId, "reFill")
					
					self.MixTypFac[Typ] = MixFac
					self.MixTypLvl[Typ] = 0;
					
					local fillTypes = getUserAttribute(childId, "fillTypes");
					if fillTypes == nil then
						fillTypes = getUserAttribute(childId, "fruitTypes");
					end
					if fillTypes ~= nil then
						local types = Utils.splitString(" ", fillTypes);
						for k,v in pairs(types) do
							local desc = Fillable.fillTypeNameToDesc[v];
							if desc ~= nil then
								acceptedFillTypes[desc.index] = true;
								self.fillTypeToMixType[desc.index] = Typ;
								if not self.MixTypName[Typ] then
									self.MixTypName[Typ] = {};
									self.MixTypName[Typ].index = desc.index
									self.MixTypName[Typ].name = desc.nameI18N
									self.MSG[Typ] = {msg = self.name..desc.nameI18N.." "..g_i18n:getText(L_SiloLeer), send = true};
								end
							else
								print("Error: (MischStation) invalid fillType "..v.." in "..getName(childId));
							end;
						end;
					end;
					if reFill and self.ForageTrigger then
						acceptedFillTypes[self.ForageTrigger.fillType] = true;
					end;
					local tipTrigger = FeedingTroughTipTrigger:new(self.isServer, self.isClient);
					tipTrigger.priceMultipliers = {};
					tipTrigger.acceptedFillTypes = acceptedFillTypes;
					tipTrigger:load(childId,self);
					tipTrigger:register(true);
					
					removeTrigger(tipTrigger.triggerId);
					addTrigger(tipTrigger.triggerId , "FillTriggerCallback", self);
					
					tipTrigger.capacity = Utils.getNoNil(getUserAttribute(childId, "capacity"),10000)
					if tipTrigger.fillPlane ~= nil then
						tipTrigger.moveScale = (tipTrigger.moveMaxY-tipTrigger.moveMinY) / tipTrigger.capacity;
					end;
					
					tipTrigger.updateFillPlane = function(trigger) self:updatePlane(trigger); end;
					
					if WalzenId then
						if getUserAttribute(WalzenId, "Schnecken") then
							local group = getChildAt(WalzenId, i-1);
							tipTrigger.Schnecken = {};
							tipTrigger.Schnecken.t = 0;
							tipTrigger.Schnecken.d = 1;
							tipTrigger.Schnecken.node1 = getChildAt(group, 0);
							tipTrigger.Schnecken.node2 = getChildAt(group, 1);
							tipTrigger.Schnecken.sound = getChildAt(group, 2);
							setVisibility(tipTrigger.Schnecken.sound, false);
						else
							tipTrigger.Walzen = {}
							tipTrigger.Walzen.t = 0
							tipTrigger.Walzen.node = getChildAt(WalzenId, i-1);
							setShaderParameter(tipTrigger.Walzen.node, "uvScrollSpeed", 0,0,0,0,false);
							tipTrigger.Walzen.sound = getChildAt(tipTrigger.Walzen.node, 0);
							setVisibility(tipTrigger.Walzen.sound, false);
						end;
					end;
					if TipMarkerId then
						tipTrigger.Marker = {}
						tipTrigger.Marker.node = getChildAt(TipMarkerId, i-1);
						tipTrigger.Marker.moveMinY = Utils.getNoNil(getUserAttribute(TipMarkerId, "moveMinY"), 0);
						tipTrigger.Marker.moveMaxY = Utils.getNoNil(getUserAttribute(TipMarkerId, "moveMaxY"), 0);
						tipTrigger.Marker.moveScale = Utils.getNoNil(getUserAttribute(TipMarkerId, "moveScale"), 0.001)*0.01;
						tipTrigger.Marker.moveBackScale = (tipTrigger.Marker.moveMaxY-tipTrigger.Marker.moveMinY)/Utils.getNoNil(getUserAttribute(TipMarkerId, "moveBackTime"), 10000);
					end;
					if BaleTriggerId and self.isServer then
						tipTrigger.BaleTrigger = getChildAt(BaleTriggerId, i-1);
						addTrigger(tipTrigger.BaleTrigger, "BaleTriggerCallback", self);
					end;
					if ShovelTargetId ~= nil and self.isServer then
						tipTrigger.Target = {}
						tipTrigger.Target = ShovelTarget:new();
						tipTrigger.Target.nodeId = getChildAt(ShovelTargetId, i-1);
						tipTrigger.Target.fillTypes = acceptedFillTypes;
						g_currentMission:addNodeObject(tipTrigger.Target.nodeId, tipTrigger.Target);
						g_currentMission:addNonUpdateable(tipTrigger.Target);
						tipTrigger.Target.addShovelFillLevel = function(target, shovel, fillLevelDelta, fillType) self:addShovelFillLevel(target, shovel, fillLevelDelta, fillType); end;
					end;

					table.insert(self.TipTriggers, tipTrigger);
				end;
			end;
		end;
				
		local LvLIndicatorIndex = getUserAttribute(self.nodeId,"LvLIndicator");
		if LvLIndicatorIndex then
			local LvLIndicator = Utils.indexToObject(self.nodeId, LvLIndicatorIndex);
			self.LvLIndicator = {}
			self.LvLIndicator.capacity = getUserAttribute(LvLIndicator, "capacity")
			local movingIndex = getUserAttribute(LvLIndicator, "movingIndex");
			if movingIndex ~= nil then
				self.LvLIndicator.movingId = Utils.indexToObject(LvLIndicator, movingIndex);
				if self.LvLIndicator.movingId ~= nil then
					self.LvLIndicator.moveMinY = Utils.getNoNil(getUserAttribute(LvLIndicator, "moveMinY"), 0);
					self.LvLIndicator.moveMaxY = Utils.getNoNil(getUserAttribute(LvLIndicator, "moveMaxY"), 0);
					if not self.LvLIndicator.capacity then self.LvLIndicator.capacity = 500000 end;
					self.LvLIndicator.moveScale = (self.LvLIndicator.moveMaxY-self.LvLIndicator.moveMinY) / self.LvLIndicator.capacity;
				end;
			end;
		
		end
		
		local LampIndex = getUserAttribute(self.nodeId,"LampIndex");
		if LampIndex ~= nil then         
			local Lamp = Utils.indexToObject(self.nodeId, LampIndex);
			if Lamp ~= nil then
				self.Lamp = {}
				local numChildren = getNumOfChildren(Lamp);
				for i = 1, numChildren do
					self.Lamp[i] = {}
					self.Lamp[i].node = getChildAt(Lamp,i-1)
					self.Lamp[i].t = 0;
					self.Lamp[i].s = 0; 
				end;
			end;
		end;
		
		local PlayerTriggerIndex = getUserAttribute(self.nodeId,"Interact");
		if PlayerTriggerIndex then
			local PlayerTrigger = Utils.indexToObject(self.nodeId, PlayerTriggerIndex);
			if PlayerTrigger then
				self.PlayerTrigger = PlayerTrigger;
				addTrigger(self.PlayerTrigger, "PlayerTriggerCallback", self);
			end;
		end;
		
		local MixerIndex = getUserAttribute(self.nodeId,"MixerIndex");
		if MixerIndex ~= nil then         
			local Mixer = Utils.indexToObject(self.nodeId, MixerIndex);
			if Mixer ~= nil then
				self.Mixer = {}
				local numChildren = getNumOfChildren(Mixer);
				for i = 1, numChildren do
					self.Mixer[i] = {}
					self.Mixer[i].node = getChildAt(Mixer,i-1)
					self.Mixer[i].t = 0;
					self.Mixer[i].s = 0; 
				end;
			end;
		end;
		
		if not MischStation.RunAsGE then
			local AreaIndex = getUserAttribute(self.nodeId,"Area");
			if AreaIndex ~= nil then         
				local AreaStart = Utils.indexToObject(self.nodeId, AreaIndex);
				if AreaStart ~= nil then
					self.Area = {}
					self.Area.start  = AreaStart;
					self.Area.width	 = getChildAt(AreaStart,0);
					self.Area.height = getChildAt(AreaStart,1);
					local x,_,z = getWorldTranslation(self.Area.start);
					local x1,_,z1 = getWorldTranslation(self.Area.width);
					local x2,_,z2 = getWorldTranslation(self.Area.height);
					
					Utils.updateDestroyCommonArea(x, z, x1, z1, x2, z2);
				end;
			end;
		end;
		
		if self.isClient then
			local MixFillPS = Utils.indexToObject(self.nodeId, getUserAttribute(self.nodeId,"MixFillPS"));
			if MixFillPS ~= nil then
				self.MixFillPS = {};
				local numChildren = getNumOfChildren(MixFillPS);
				for i = 1, numChildren do
					self.MixFillPS[i] = {};
					local child = getChildAt(MixFillPS,i-1)
					local psData = {};
					local particleSystem = Utils.getNoNil(getUserAttribute(child, "particleSystem"), "PSDL");
					psData.psFile = self.MapPfad.."PS/"..particleSystem .. ".i3d";
					psData.posX, psData.posY, psData.posZ = getTranslation(child);
					psData.forceNoWorldSpace = true;
					Utils.loadParticleSystemFromData(psData, self.MixFillPS[i], nil, false, nil, MischStation.Dir, getParent(child));
				end
			end
			local MixerPS = Utils.indexToObject(self.nodeId, getUserAttribute(self.nodeId,"MixerPS"));
			if MixerPS ~= nil then
				self.MixerPS = {};
				local numChildren = getNumOfChildren(MixerPS);
				for i = 1, numChildren do
					self.MixerPS[i] = {};
					local child = getChildAt(MixerPS,i-1)
					local psData = {};
					psData.psFile = self.MapPfad.."PS/MixerPS.i3d";
					psData.posX, psData.posY, psData.posZ = getTranslation(child);
					psData.forceNoWorldSpace = true;
					Utils.loadParticleSystemFromData(psData, self.MixerPS[i], nil, false, nil, MischStation.Dir, getParent(child));
				end
			end
			local MixerSound = Utils.indexToObject(self.nodeId, getUserAttribute(self.nodeId,"MixerSound"));
			if MixerSound ~= nil then
				self.MixerSound = MixerSound;
				setVisibility(self.MixerSound, false);
			end;
		end
		
		local FillPipeIndex = getUserAttribute(self.nodeId, "FillPipeIndex")
		if FillPipeIndex ~= nil then         
			local FillPipe = Utils.indexToObject(self.nodeId, FillPipeIndex);
			if FillPipe ~= nil then
				self.FillPipe = {}
				self.FillPipe.rotNode = FillPipe;
				self.FillPipe.transNode = getChildAt(getChildAt(FillPipe,0),0);
				self.ForageTriggerRaycast = getChildAt(self.FillPipe.transNode,0)
				local split1 = Utils.splitString(" ", InputBinding.getKeyNamesOfDigitalAction(InputBinding.MischStation_RMINUS));
				self.HelpText1 = InputBinding.getKeyNamesOfDigitalAction(InputBinding.MischStation_RPLUS).."/"..split1[2]..":      "..g_i18n:getText("MischStation_RPLUS");
				local split2 = Utils.splitString(" ", InputBinding.getKeyNamesOfDigitalAction(InputBinding.MischStation_TMINUS));
				self.HelpText2 = InputBinding.getKeyNamesOfDigitalAction(InputBinding.MischStation_TPLUS).."/"..split2[2]..":      "..g_i18n:getText("MischStation_TPLUS");
				self.FillPipe.Sound = getChildAt(FillPipe,1)
				setVisibility(self.FillPipe.Sound, false);
			end;
		end;
		
		--delete(xmlFile);
		
		self.MischStationDirtyFlag = self:getNextDirtyFlag();
		self.updateFillPlane = true;
		
		if MischStation.RunAsGE then
			g_currentMission:addNodeObject(self.nodeId, self)
			g_currentMission:addOnCreateLoadedObjectToSave(self)
		end;
		
		self:SetLamp()
		
	end;
  
	return true;
end;

function MischStation:getSaveAttributesAndNodes(nodeIdent)
	
	local attributes, nodes = "","";
	
	if not MischStation.RunAsGE then
		attributes, nodes = MischStation:superClass().getSaveAttributesAndNodes(self, nodeIdent);
	end;
	
	attributes = attributes.. ' MixLvl="'..self.MixLvl..'"';
   
	if self.FillPipe then
		local rx,ry,rz = getRotation(self.FillPipe.rotNode)
		local tx,ty,tz = getTranslation(self.FillPipe.transNode)
		attributes = attributes..' PipeRot="'..ry..'" PipeTrans="'..tz..'"';
	end;
		
	local FillTypesNum = 0;
	
	for i = 1, table.getn(self.MixTypLvl) do
		if FillTypesNum>0 then
			nodes = nodes.."\n";
		end;
		nodes = nodes..nodeIdent..'<MixType Typ="'.. i..'" Lvl="'..self.MixTypLvl[i]..'"/>';
		FillTypesNum = FillTypesNum+1;
	end;
	
    return attributes,nodes;
end;

function MischStation:loadFromAttributesAndNodes(xmlFile, Key)
	if not MischStation.RunAsGE and not MischStation:superClass().loadFromAttributesAndNodes(self, xmlFile, Key) then
		return false;
	end;
	--Debug(self.db.debug,	xmlFile, Key)	
	local MixLvl = getXMLFloat(xmlFile, Key.."#MixLvl")
	if MixLvl == nil then return false end;
	self.MixLvl = Utils.getNoNil(getXMLFloat(xmlFile, Key.."#MixLvl"),0);
	--Debug(self.db.debug,	"have "..Key.."#MixLvl "..tostring(MixLvl))
	
	if self.FillPipe then
		local rx,ry,rz = getRotation(self.FillPipe.rotNode)
		local tx,ty,tz = getTranslation(self.FillPipe.transNode)
		ry = Utils.getNoNil(getXMLFloat(xmlFile, Key.."#PipeRot"),math.rad(-179.9));
		tz = Utils.getNoNil(getXMLFloat(xmlFile, Key.."#PipeTrans"),0);
		setRotation(self.FillPipe.rotNode,rx,ry,rz);
		setTranslation(self.FillPipe.transNode,tx,ty,tz);
	end;
	
	local i=0;
	while true do
		local MixTypeKey = Key..string.format(".MixType(%d)", i);
		if not hasXMLProperty(xmlFile, MixTypeKey) then
			break;
		end;
		local MixLevel = getXMLFloat(xmlFile, MixTypeKey.."#Lvl");
		local MixType = getXMLInt(xmlFile, MixTypeKey.."#Typ");
		if MixLevel ~= nil and MixType ~= nil and self.MixTypLvl[MixType] then
			self.MixTypLvl[MixType] = MixLevel
		end;
		i = i + 1;
	end;
	
	for k,v in pairs(self.MSG) do
		v.send = nil;
	end;
	
	self.updateFillPlane = true

	return true;
end;

function MischStation:readStream(streamId, connection)
	
	MischStation:superClass().readStream(self, streamId, connection);
	
	for i = 1, table.getn(self.MixTypLvl) do
		self.MixTypLvl[i] = streamReadFloat32(streamId);
	end
	self.MixLvl = streamReadFloat32(streamId);
	local isFilling = streamReadBool(streamId);
	if isFilling then
		self.ForageTrigger:startFill();
	else
		self.ForageTrigger:stopFill();
	end;
	
	if self.FillPipe then
		local rx,ry,rz = getRotation(self.FillPipe.rotNode)
		local tx,ty,tz = getTranslation(self.FillPipe.transNode)
		ry = streamReadFloat32(streamId);
		tz = streamReadFloat32(streamId);
		setRotation(self.FillPipe.rotNode,rx,ry,rz);
		setTranslation(self.FillPipe.transNode,tx,ty,tz);
	end;
	
	for k,v in pairs(self.MSG) do
		v.send = nil;
	end;
	
	self.updateFillPlane = true;
	
end;

function MischStation:writeStream(streamId, connection)
	
	MischStation:superClass().writeStream(self, streamId, connection);
	
	for i = 1, table.getn(self.MixTypLvl) do
		streamWriteFloat32(streamId, self.MixTypLvl[i]);
	end;
	streamWriteFloat32(streamId, self.MixLvl);
    streamWriteBool(streamId, self.ForageTrigger.isFilling);
	
	if self.FillPipe then
		local rx,ry,rz = getRotation(self.FillPipe.rotNode)
		local tx,ty,tz = getTranslation(self.FillPipe.transNode)
		streamWriteFloat32(streamId, ry);
		streamWriteFloat32(streamId, tz);
	end;
end;

function MischStation:readUpdateStream(streamId, timestamp, connection)
	
	MischStation:superClass().readUpdateStream(self, streamId, timestamp, connection);
	
	if connection:getIsServer() then
		for i = 1, table.getn(self.MixTypLvl) do
			local lvl = streamReadFloat32(streamId);
			if lvl > self.MixTypLvl[i] then
				self:updateTippingAnimation(self.MixTypName[i].index, self.MixTypLvl[i] - lvl)
			end
			self.MixTypLvl[i] = lvl;
		end
		if streamReadBool(streamId) then
			local lvl = streamReadFloat32(streamId); --self.MixLvl =
			if self.ForageTrigger then
				self:updateTippingAnimation(self.ForageTrigger.fillType, self.MixLvl - lvl)
			end
			self.MixLvl = lvl;
		else
			self.MixLvl = streamReadFloat32(streamId);
		end
		local isFilling = streamReadBool(streamId);
        if isFilling then
            self.ForageTrigger:startFill();
        else
            self.ForageTrigger:stopFill();
        end;
		self.updateFillPlane = true;
	end;
end;

function MischStation:writeUpdateStream(streamId, connection, dirtyMask)
	
	MischStation:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);
	
	if not connection:getIsServer() then
		for i = 1, table.getn(self.MixTypLvl) do
			streamWriteFloat32(streamId, self.MixTypLvl[i]);
		end;
		streamWriteBool(streamId, self.sendRefill);
		streamWriteFloat32(streamId, self.MixLvl);
		streamWriteBool(streamId, self.ForageTrigger.isFilling);
		self.sendRefill = nil;
	end;
end;

function MischStation:update(dt)
	
	if not self.menueaddet then
		self.menueaddet = true;
		if g_currentMission.ModMenue then
			g_currentMission.ModMenue:Add(self.optionen);
		end;
		if self.isServer then
			for i=1, table.getn(self.TipTriggers) do
				local Target = self.TipTriggers[i].Target
				local object = g_currentMission:getNodeObject(Target.nodeId)
				if object ~= Target then
					g_currentMission:addNodeObject(Target.nodeId, Target);
				end
			end
		end;
	end;
	
	if self.MixLvl >= 1 then
		local dir = -1;
		if self.Mixer then
			for i=1, table.getn(self.Mixer) do
				local r = 0.005 + (i/10000);
				rotate(self.Mixer[i].node, 0, (r * dt) * dir, 0);
				dir = dir * -1;
			end;
		end;
		if self.MixerPS and not self.MixerPSEmit then
			for i = 1,table.getn(self.MixerPS) do
				Utils.setEmittingState(self.MixerPS[i], true);
			end
			self.MixerPSEmit = true
		end;
		if self.MixerSound and not self.MixerSoundOn then
			setVisibility(self.MixerSound, true);
			self.MixerSoundOn = true;
		end
	else
		if self.MixerPS and self.MixerPSEmit then
			for i = 1,table.getn(self.MixerPS) do
				Utils.setEmittingState(self.MixerPS[i], false);
			end
			self.MixerPSEmit = nil;
		end;
		if self.MixerSound and self.MixerSoundOn then
			setVisibility(self.MixerSound, false);
			self.MixerSoundOn = nil;
		end;
	end;
	
	if self.changeAllowed then
		g_currentMission:addExtraPrintText(self.name);
		local text = string.format("%s",Fillable.fillTypeIndexToDesc[Fillable.FILLTYPE_FORAGE].nameI18N.." [l]");
		local Percentage = math.abs(self.MixLvl / self.LvLIndicator.capacity * 100);
		text = text.." "..string.format("%d (%d%%)",self.MixLvl,Percentage);
		g_currentMission:addExtraPrintText(text);
		for i = 1, table.getn(self.MixTypName) do
			local text = string.format("%s",self.MixTypName[i].name.." [l]");
			local Percentage = math.abs(self.MixTypLvl[i] / self.TipTriggers[i].capacity * 100);
			text = text.." "..string.format("%d (%d%%)",self.MixTypLvl[i],Percentage);
			g_currentMission:addExtraPrintText(text);
		end;
		
		if self.FillPipe then
			g_currentMission:addExtraPrintText(self.HelpText1)
			g_currentMission:addExtraPrintText(self.HelpText2)
		end;
		
		if not g_currentMission.controlPlayer then
			self.changeAllowed = false;
		end;
	end;
	
	if self.ForageTrigger then
		if self.isServer then
			local trailer = self.ForageTrigger.siloTrailer;
			if self.ForageTrigger.fill >= 4 and trailer ~= nil and not self.ForageTrigger.fillDone then
				trailer:resetFillLevelIfNeeded(self.ForageTrigger.fillType);
				local fillLevel = trailer:getFillLevel(self.ForageTrigger.fillType);
				if self.MixLvl > 0 and trailer:allowFillType(self.ForageTrigger.fillType, false) then
					local deltaFillLevel = math.min(self.ForageTrigger.fillLitersPerSecond*0.001*dt, self.MixLvl);
					trailer:setFillLevel(fillLevel+deltaFillLevel, self.ForageTrigger.fillType);
					local newFillLevel = trailer:getFillLevel(self.ForageTrigger.fillType);
					if fillLevel ~= newFillLevel then
						self.MixLvl = math.max(self.MixLvl-(newFillLevel-fillLevel), 0);
						self.ForageTrigger:startFill();
						self.updateFillPlane = true;
						if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
							self.ForageTrigger.fillDone = true; -- Befllen Abrechen
							self.ForageTrigger:stopFill();
						end
					else
						self.ForageTrigger.fillDone = true; -- trailer is full
						self.ForageTrigger:stopFill();
					end;
				else
					self.ForageTrigger.fillDone = true; -- silo is empty or trailer does not support fill type
					self.ForageTrigger:stopFill();
				end;
				self.SendUpdate = true;
			elseif self.ForageTriggerTrailer and trailer == nil then
				self.SendUpdate = true;
			end;
			if self.ForageTrigger.fillDone and self.ForageTrigger.fill <= 0 then
				self.ForageTrigger.fillDone = false;
			end
			self.ForageTriggerTrailer = trailer;
		end;
		if self.ForageTrigger.isFilling and self.ForageTrigger.Schnecke then
			rotate(self.ForageTrigger.Schnecke, 0, 0, (0.01 * dt));
		end
	end;
end;

function MischStation:updateTick(dt)
	-- self.printUpdate=(self.printUpdate or 0)+dt
	-- if self.printUpdate >= 10000 then
		-- self.printUpdate = 0
		-- print(table.show(self.ForageTrigger,"self.ForageTrigger",nil,4))
	-- end
	
	self.updateMs = self.updateMs + (dt * g_currentMission.missionStats.timeScale);
	if self.updateMs >= 60000 then
		
		self.updateMs = self.updateMs - 60000;
		self.updateMin = self.updateMin + 1;
		if self.isServer then
			local need = (self.foragePerHour/60) --Bedarf pro min
			if self.LvLIndicator and self.LvLIndicator.capacity then
				need = math.min(need, self.LvLIndicator.capacity - self.MixLvl)
			end
			
			local SumFac = 0;
			for i = 1, table.getn(self.MixTypFac) do
				SumFac = SumFac + self.MixTypFac[i] --Summe aller Factoren
			end
			
			local FacNeed = need / SumFac; -- Bedarf / Summe Factoren
			
			for i = 1, table.getn(self.MixTypLvl) do -- Kontrolle min lvl
				FacNeed = math.min(self.MixTypLvl[i] , FacNeed * self.MixTypFac[i]) / self.MixTypFac[i]; -- minlvl factor neu aufrechnen; 
			end
			local leer
			for i = 1, table.getn(self.MixTypLvl) do
				self.MixTypLvl[i] = math.max(self.MixTypLvl[i] - (FacNeed * self.MixTypFac[i]),0) -- lvl abzug
				if self.MixTypLvl[i] <= 0 then leer = true end;
			end
			
			self.MixLvl = self.MixLvl + (FacNeed * SumFac); -- add forage 
			
			self.SendUpdate = true;
			self.updateFillPlane = true;
		end;
		if self.updateMin >= self.updateIntervall then
			self.updateMin = self.updateMin - self.updateIntervall
			self.notFeedingTrough = nil;
		end;
	end;
		
	if self.updateFillPlane then
		self.updateFillPlane = nil;
		for i = 1 ,table.getn(self.TipTriggers) do
			if self.TipTriggers[i].updateFillPlane ~= nil then
				self.TipTriggers[i]:updateFillPlane();
			end;
		end;
		if self.LvLIndicator and self.LvLIndicator.movingId ~= nil then
			local x,y,z = getTranslation(self.LvLIndicator.movingId);
			local newY = math.min(self.LvLIndicator.moveMinY+self.MixLvl*self.LvLIndicator.moveScale, self.LvLIndicator.moveMaxY);
			setTranslation(self.LvLIndicator.movingId, x, newY, z);
			self.SendUpdate = true
		end;
		self:SetLamp()
	end;
	
	for i = 1 ,table.getn(self.TipTriggers) do
		if self.TipTriggers[i].Walzen then
			local TTW = self.TipTriggers[i].Walzen
			if TTW.On then
				TTW.t = TTW.t - dt;
				if TTW.t <= 0 then
					setShaderParameter(TTW.node, "uvScrollSpeed", 0,0,0,0,false);
					setVisibility(TTW.sound, false);
					TTW.On = nil;
				end;
			end;
		elseif self.TipTriggers[i].Schnecken then
			local TTW = self.TipTriggers[i].Schnecken
			if TTW.On then
				TTW.t = TTW.t - dt;
				if TTW.t <= 0 then
					setVisibility(TTW.sound, false);
					TTW.On = nil;
				end;
				rotate(TTW.node1, (-0.01 * dt * TTW.d), 0, 0);
				rotate(TTW.node2, (0.01 * dt * TTW.d), 0, 0);
			end;
		end;
		local Marker = self.TipTriggers[i].Marker
		if Marker ~= nil then
			local x,y,z = getTranslation(Marker.node);
			local newY = math.max(y-dt*Marker.moveBackScale, Marker.moveMinY);
			setTranslation(Marker.node, x, newY, z);
		end;
	end;

	if self.MixLvl >= 1 then
		local t = math.rad(math.floor((g_currentMission.time/20) % 360));
		local sinus = math.sin(t)/40;
		local cosin = math.cos(t)/20;
		if self.LvLIndicator then
			setShaderParameter(self.LvLIndicator.movingId, "uvOffset", sinus ,cosin ,0,0,false);
		end;
	end;
	
	if self.FillPipeMove or self.FillPipeMoveSoundOn then
		if self.FillPipeMove then
			self.FillPipeMove = nil
			self.FillPipeMoveSoundOn = true
		else
			self.FillPipeMoveSoundOn = nil
			setVisibility(self.FillPipe.Sound, false);
		end;
	end;
	
	if self.FillPipe then
		local change = false;
		if self.changeAllowed then
			local rx,ry,rz = getRotation(self.FillPipe.rotNode);
			local tx,ty,tz = getTranslation(self.FillPipe.transNode);
			local newry, newtz = ry, tz;
			if InputBinding.isPressed(InputBinding.MischStation_RPLUS) then
				newry = ry + 0.0005 * dt
				newry = math.max(math.rad(-180),math.min(0,newry))
				if math.abs(newry - ry) > 0.0001 then change = true end;
			elseif InputBinding.isPressed(InputBinding.MischStation_RMINUS) then
				newry = ry - 0.0005 * dt
				newry = math.max(math.rad(-180),math.min(0,newry))
				if math.abs(newry - ry) > 0.0001 then change = true end;
			end
			if InputBinding.isPressed(InputBinding.MischStation_TPLUS) then
				newtz = tz - 0.0005 * dt
				newtz = math.max(-2.65,math.min(0,newtz))
				if math.abs(newtz - tz) > 0.0001 then change = true end;
			elseif InputBinding.isPressed(InputBinding.MischStation_TMINUS) then
				newtz = tz + 0.0005 * dt
				newtz = math.max(-2.65,math.min(0,newtz))
				if math.abs(newtz - tz) > 0.0001 then change = true end;
			end
			if change == true then
				self:SetFillPipe(newry, newtz)
			end;
		end;
	end;
	
	if self.SendUpdate then
		self.SendUpdate = nil
		self:raiseDirtyFlags(self.MischStationDirtyFlag);
	end
	
	self:updateLamp(dt)
	
	if self.isServer and self.ForageTrigger and self.ForageTrigger.fill < 4 then
		if self.notFeedingTrough ~= true and self.ForageTriggerRaycast then
			self:findFeedingTrough(dt)
		end;
	end;
end;

function MischStation:getNoAllowedText(trailer)
	
	if trailer.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
		
		if not self.trailerTipTrigger[trailer].acceptedFillTypes[trailer.currentFillType] then
			return Fillable.fillTypeIndexToDesc[trailer.currentFillType].nameI18N .. g_i18n:getText("notAcceptedHere");
		else
			return g_i18n:getText("Here_is_no_space");
		end
	end
	
	return nil;
end;
					
function MischStation:getTipTriggerFillLevel(trigger)
	local maxFillLvl = 0;
	for fillType in pairs(trigger.acceptedFillTypes) do
		if self.fillTypeToMixType[fillType] then 
			maxFillLvl = math.max(self.MixTypLvl[self.fillTypeToMixType[fillType]], maxFillLvl);
		end;
	end;
	return maxFillLvl;
end

function MischStation:getHasSpaceForTipping(fillType)
	
	if self.fillTypeToMixType[fillType] then
		for i = 1 ,table.getn(self.TipTriggers) do
			if self.TipTriggers[i].acceptedFillTypes[fillType] and self.TipTriggers[i].capacity <= self.MixTypLvl[self.fillTypeToMixType[fillType]] then
				return false;
			end;
		end;
	elseif self.ForageTrigger and self.ForageTrigger.fillType == fillType then
		if self.LvLIndicator and self.LvLIndicator.capacity then
			if self.LvLIndicator.capacity <= self.MixLvl then
				return false;
			end;
		end;
	end;
	return true;			
end;	

function MischStation:getTipInfoForTrailer(trailer, tipReferencePointIndex)
    
	local minDistance, bestPoint, trigger = math.huge, nil, nil
	
	for i = 1, table.getn(self.TipTriggers) do
		local distance, Point = self.TipTriggers[i]:getTipDistanceFromTrailer(trailer, tipReferencePointIndex);
		if distance < minDistance then
			minDistance = distance;
			bestPoint = Point;
			trigger = i;
		end;
	end;
	
	self.trailerTipTrigger[trailer] = self.TipTriggers[trigger];
	
	local isAllowed = true;
	if not self.TipTriggers[trigger].acceptedFillTypes[trailer.currentFillType] then
		isAllowed = false;
	elseif not self:getHasSpaceForTipping(trailer.currentFillType) then
		isAllowed = false;
	end
	
    return isAllowed, minDistance, bestPoint;
end

function MischStation:updateTrailerTipping(trailer, fillDelta, fillType)
	
	if fillDelta < 0 then
		if self.fillTypeToMixType[fillType] then
			self.MixTypLvl[self.fillTypeToMixType[fillType]] = self.MixTypLvl[self.fillTypeToMixType[fillType]] - fillDelta;
		elseif self.ForageTrigger and self.ForageTrigger.fillType == fillType then
			self.MixLvl = self.MixLvl - fillDelta;
			self.updateFillPlane = true;
			self.sendRefill = true;
		end
		self:updateTippingAnimation(fillType, fillDelta)
		
		self.SendUpdate = true
	end;
end;

function MischStation:updateTippingAnimation(fillType, fillDelta)
	
	for i = 1, table.getn(self.TipTriggers) do
		if self.TipTriggers[i].acceptedFillTypes[fillType] then
			local trigger = self.TipTriggers[i];
			if trigger.updateFillPlane ~= nil then
				trigger:updateFillPlane()
			end;
			if trigger.Walzen then
				if not trigger.Walzen.On then
					trigger.Walzen.On = true;
					setShaderParameter(trigger.Walzen.node, "uvScrollSpeed", 0,-0.3,0,0,false);
					setVisibility(trigger.Walzen.sound, true);
				end
				trigger.Walzen.t = 10000;
			elseif trigger.Schnecken then
				if not trigger.Schnecken.On then
					trigger.Schnecken.On = true;
					setVisibility(trigger.Schnecken.sound, true);
				end
				if self.ForageTrigger and self.ForageTrigger.fillType == fillType then
					trigger.Schnecken.d = -1;
				else
					trigger.Schnecken.d = 1;
				end
				trigger.Schnecken.t = 10000;
			end;
			if trigger.Marker then
				local x,y,z = getTranslation(trigger.Marker.node);
				local newY = math.min(y-fillDelta*trigger.Marker.moveScale, trigger.Marker.moveMaxY);
				setTranslation(trigger.Marker.node, x, newY, z);
			end;
			break;
		end;
	end;
	
	self:SetLamp()
end;

function MischStation:addShovelFillLevel(target, shovel, fillLevelDelta, fillType)
	if target.fillTypes[fillType] ~= nil then
		if self:getHasSpaceForTipping(fillType) then
			for i = 1 ,table.getn(self.TipTriggers) do
				if self.TipTriggers[i].acceptedFillTypes[fillType] then
					fillLevelDelta = math.min(fillLevelDelta, self.TipTriggers[i].capacity - self.MixTypLvl[self.fillTypeToMixType[fillType]]);
					self:updateTrailerTipping(shovel, -fillLevelDelta, fillType, self.TipTriggers[i])
					break;
				end;
			end;
        end;
		return fillLevelDelta;
    end;
    return 0;
end;

function MischStation:findFeedingTrough(dt)

    local x,y,z = getWorldTranslation(self.ForageTriggerRaycast);
			
    self.triggerFound = 0;
    raycastAll(x, y, z, 0, -1 ,0, "triggerRaycast", 7, self);

	if self.triggerFound ~= 0 then
		if self.triggerFound.updateTrailerTipping and self.triggerFound.animalHusbandry then
			if self.MixLvl > 0 and self.triggerFound.animalHusbandry:getHasSpaceForTipping(self.ForageTrigger.fillType) then
				local deltaFillLevel = math.min(self.ForageTrigger.fillLitersPerSecond*0.001*dt, self.MixLvl);
				self.ForageTrigger:startFill();
				self.updateFillPlane = true;
				self.SendUpdate = true;
				self.MixLvl = math.max(self.MixLvl - deltaFillLevel, 0);
				self.triggerFound:updateTrailerTipping(self, -deltaFillLevel, self.ForageTrigger.fillType, self.triggerFound);
			elseif self.ForageTrigger.isFilling then
				self.ForageTrigger:stopFill();
				self.SendUpdate = true;
				self.notFeedingTrough = true;
			end;
		elseif self.ForageTrigger.isFilling then
			self.ForageTrigger:stopFill();
			self.SendUpdate = true;
			self.notFeedingTrough = true;
		end
	elseif self.ForageTrigger.isFilling then
		self.ForageTrigger:stopFill();
		self.SendUpdate = true;
		self.notFeedingTrough = true;
	end

end;

function MischStation:triggerRaycast(transformId, x, y, z, distance)
	for k,v in pairs(g_currentMission.tipTriggers) do
		if v.triggerId and v.triggerId == transformId then
			if v.acceptedFillTypes[self.ForageTrigger.fillType] then
				self.triggerFound = v
				return false;
			end
		end
    end
    return true;
end;

function MischStation:findTrailerRaycastCallback(transformId, x, y, z, distance)
	local object = g_currentMission:getNodeObject(transformId)
	if object ~= nil and object ~= self and object.addShovelFillLevel ~= nil and object.getAllowShovelFillType ~= nil then
		MischStation.objectFound = object
		return true
	end
    return true;
end;

function MischStation:SetLamp()

	local need = (self.foragePerHour/60) --Bedarf pro min
	if self.LvLIndicator and self.LvLIndicator.capacity then
		need = math.min(need, self.LvLIndicator.capacity - self.MixLvl)
	end;
	local leer
	for i = 1, table.getn(self.MixTypLvl) do
		if self.MixTypLvl[i] <= 0 then
			leer = true;
			self:SendMSG(i,true);
		else
			self:SendMSG(i,false);
		end;
	end
	if need <= 0 or leer then
		if need <= 0 then
			self:updateLamp(2, 3);
			self:SendMSG("voll",true);
		else
			self:updateLamp(2, 0);
			if self.LvLIndicator and self.LvLIndicator.capacity then
				if (self.LvLIndicator.capacity * 0.9) > self.MixLvl then
					self:SendMSG("voll",false);
				end;
			end;
		end
		if leer then
			self:updateLamp(1, 3, 500)
		else
			self:updateLamp(1, 0)
		end
		if self.MixFillPS and self.FillMixPSEmit then
			for i = 1, table.getn(self.MixFillPS) do
				Utils.setEmittingState(self.MixFillPS[i], false);
			end;
			self.FillMixPSEmit = nil;
		end
		self:updateLamp(3, 0)
	else
		self:updateLamp(1, 0)
		self:updateLamp(2, 0)
		self:updateLamp(3, 1)
		if self.MixFillPS and not self.FillMixPSEmit then
			self.FillMixPSEmit = true;
			for i = 1, table.getn(self.MixFillPS) do
				Utils.setEmittingState(self.MixFillPS[i], true);
			end;
		end
		if self.LvLIndicator and self.LvLIndicator.capacity then
			if (self.LvLIndicator.capacity * 0.9) > self.MixLvl then
				self:SendMSG("voll",false);
			end;
		end;
	end;
end;

function MischStation:SetFillPipe(newry, newtz, noEventSend)
	
	local rx,ry,rz = getRotation(self.FillPipe.rotNode);
	local tx,ty,tz = getTranslation(self.FillPipe.transNode);
			
	setRotation(self.FillPipe.rotNode,rx,newry,rz)
	setTranslation(self.FillPipe.transNode,tx,ty,newtz)
	
	if math.abs(newtz - tz) > 0.0001 or math.abs(newry - ry) > 0.0001 then 
		self.FillPipeMove = true;
		setVisibility(self.FillPipe.Sound, true);
		self.notFeedingTrough = nil;
	end;
		
	if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(MischStationSetFillPipeEvent:new(self, newry, newtz), nil, nil, self);
        else
            g_client:getServerConnection():sendEvent(MischStationSetFillPipeEvent:new(self, newry, newtz));
        end
    end
end;

function MischStation:updateLamp(i, s, t)
	if self.Lamp then
		if s ~= nil then
			if self.Lamp[i].s ~= s then
				if s == 0 then
					setVisibility(self.Lamp[i].node, false)
				elseif s == 1 then
					setVisibility(self.Lamp[i].node, true)
				elseif s == 3 then
					setVisibility(self.Lamp[i].node, true)
					self.Lamp[i].t = t or 0;
				end
				self.Lamp[i].s = s; 
			end;
		else
			for j = 1, table.getn(self.Lamp) do
				if self.Lamp[j].s == 3 then
					self.Lamp[j].t = self.Lamp[j].t + i;
					if self.Lamp[j].t >= 500 then
						self.Lamp[j].t = 0;
						setVisibility(self.Lamp[j].node,not getVisibility(self.Lamp[j].node));
					end;
				end;
			end;
		end;
	end;
end;

function MischStation:updatePlane(trigger)
	local fillLvl = self:getTipTriggerFillLevel(trigger)
	local x,y,z = getScale(trigger.fillPlane);
	local newY = math.abs(fillLvl / trigger.capacity);
	setScale(trigger.fillPlane, x, newY, z);
end;

function MischStation:SendMSG(msg,send)
	if self.MSG[msg] then
		if send and g_currentMission.LiveTicker then
			if not self.MSG[msg].send then
				self.MSG[msg].send = true
				g_currentMission.LiveTicker:Add(self.MSG[msg].msg);
			end;
		else
			self.MSG[msg].send = nil;
		end;
	end;
end;

function MischStation:PlayerTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	
	if (g_currentMission.controlPlayer and g_currentMission.player and otherId == g_currentMission.player.rootNode) then
		if (onEnter) then 
            self.changeAllowed = true;
        elseif (onLeave) then
            self.changeAllowed = false;
        end;
	end;
	
end;

function MischStation:BaleTriggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter and otherActorId ~= 0 then
		local object = g_currentMission:getNodeObject(otherActorId);
		if object ~= nil and object:isa(Bale) then
			local fillLevel = object:getFillLevel();
			local fillType = object:getFillType();
			for i = 1 ,table.getn(self.TipTriggers) do
				if self.TipTriggers[i].BaleTrigger == triggerId then
					if self.TipTriggers[i].acceptedFillTypes[fillType] and self:getHasSpaceForTipping(fillType) then
						fillLevel = math.min(fillLevel, self.TipTriggers[i].capacity - self.MixTypLvl[self.fillTypeToMixType[fillType]]);
						self:updateTrailerTipping(nil, -fillLevel, fillType, self.TipTriggers[i])
						object:delete();
						break;
					end;
				end;	
			end;
		end;
	end;
end;

function MischStation:FillTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
		
	local trailer = g_currentMission.objectToTrailer[otherShapeId];
	if trailer ~= nil and trailer.allowTipDischarge then
		if onEnter then
			if g_currentMission.trailerTipTriggers[trailer] == nil then
				g_currentMission.trailerTipTriggers[trailer] = {};
			end;
			table.insert(g_currentMission.trailerTipTriggers[trailer], self);
		elseif onLeave then
			local triggers = g_currentMission.trailerTipTriggers[trailer];
			if triggers ~= nil then
				for i=1, table.getn(triggers) do
					if triggers[i] == self then
						table.remove(triggers, i);
						if table.getn(triggers) == 0 then
							g_currentMission.trailerTipTriggers[trailer] = nil;
						end;
						break;
					end;
				end;
			end;
		end;
	end;

 end;

if MischStation.RunAsGE then
	--print("reg MischStation.onCreate")
	g_onCreateUtil.addOnCreateFunction("MischStationOnCreate", MischStation.onCreate);
else
	--print("reg MischStation.Place")
	registerPlaceableType("MischStation", MischStation);
end;

MischStationSetFillPipeEvent = {};
MischStationSetFillPipeEvent_mt = Class(MischStationSetFillPipeEvent, Event);
  
InitEventClass(MischStationSetFillPipeEvent, "MischStationSetFillPipeEvent");
  
function MischStationSetFillPipeEvent:emptyNew()
    local self = Event:new(MischStationSetFillPipeEvent_mt);
    return self;
end;
 
function MischStationSetFillPipeEvent:new(object, ry, tz)
    local self = MischStationSetFillPipeEvent:emptyNew()
    self.object = object;
    self.ry = ry;
    self.tz = tz;
    return self;
end;
 
function MischStationSetFillPipeEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.ry = streamReadFloat32(streamId);
	self.tz = streamReadFloat32(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;
 
function MischStationSetFillPipeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteFloat32(streamId, self.ry);
    streamWriteFloat32(streamId, self.tz);
end;
 
function MischStationSetFillPipeEvent:run(connection)
	self.object:SetFillPipe(self.ry, self.tz, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(MischStationSetFillPipeEvent:new(self.object, self.ry, self.tz), nil, connection, self.object);
	end;
end;